;+
;NAME:
; write_scalar_fff
;PURPOSE:
; Writes a scalar for the whole volume, e.g. divb or a weighting function
; Added SDF capability, 14-sep-2007, jmm
;-
Pro Write_scalar_fff, file, rsize, tsize, vsize, f, use_sdf = use_sdf
  If(keyword_set(use_sdf)) Then Begin
    sdf_write, file, 'rsize', long(rsize) ;corresponds to FORTRAN integer
    sdf_write, file, 'tsize', long(tsize)
    sdf_write, file, 'vsize', long(vsize)
    sdf_write, file, 'f', double(f) ;for fortran input
  Endif Else Begin
    openw, unit, file, /get_lun
    printf, unit, rsize, tsize, vsize
    printf, unit, f
    free_lun, unit
  Endelse
  Return
End
