;+
;NAME:
; weightf_fff
;PURPOSE:
; input or create a weighting function for the optimization_fff
; routine
;CALLING SEQUENCE:
; weightf_fff, wfile=wfile,weight_in=weight_in,$
;                  spherical=spherical,wtype=wtype
;INPUT:
; all via keywords
;OUTPUT:
; Into the bfields common block:
; wf = a weighting function for opotimization_fff, note that it will
;     have dimensions, rsize, tsize, vsize, which are not specified in
;     any way here, you simply have to get them right if you pass this
;     in using a file
;KEYWORDS:
; weight_in = an input function, must be (rsize, tsize, vsize)
; wfile = an input file, from which you can read in the function
;         File needs a format,
;         printf, unit, rsize, tsize, vsize
;         printf, unit, weight_function
; spherical = if set, then spherical coordinates are used
; wtype = a number for a given functional type that will be created:
;         1: Function varies as  cos((!pi/2)*(z/max(z)) Or r for spherical
;         2: Function varies as cos((!pi/2)*(dist/max(dist))) Where dist
;         is sqrt(x^2+y^2+z^2), not used for spherical -- if spherical
;         is set then you get the same as wtype=1
;         3: Function varies as the inverse of dz for variable grids
;            (or dr for spherical)
;         4: Function varies as the inverse of dV, from the origin 
;HISTORY:
; 6-jul-2007, jmm, jimm@ssl.berkeley.edu
; 29-nov-2007, jmm, added wtype=3,4 options
;-
Pro weightf_fff, wfile = wfile, weight_in = weight_in, $
                 spherical = spherical, wtype = wtype, $
                 use_sdf = use_sdf, _extra = _extra

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1, wf
  Common Obj_funct_fff_private, dV

  wf = replicate(bx[0], rsize, tsize, vsize) & wf[*] = 1.0
  If(keyword_set(weight_in)) Then Begin
    wf = weight_in
  Endif Else If(keyword_set(wfile)) Then Begin
    If(keyword_set(use_sdf)) Then Begin
      sdf_read_all, wfile
    Endif Else read_scalar_fff, file, rsize, tsize, vsize, wf
  Endif Else If(keyword_set(wtype)) Then Begin
    Case wtype Of
      1:Begin
        If(keyword_set(spherical)) Then Begin
          wf0 = cos(!pi*x/(2.0*max(x)))
          wf0 = wf0 > 0.0
          For i = 0, rsize-1 Do wf[i, *, *] = wf0[i]
        Endif Else Begin
          wf0 = cos(!pi*z/(2.0*max(z)))
          wf0 = wf0 > 0.0
          For k = 0, vsize-1 Do wf[*, *, k] = wf0[k]
        Endelse
      End
      2:Begin
        If(keyword_set(spherical)) Then Begin
          wf0 = cos(!pi*x/(2.0*max(x)))
          wf0 = wf0 > 0.0
          For i = 0, rsize-1 Do wf[i, *, *] = wf0[i]
        Endif Else Begin
          For i = 0, rsize-1 Do For j = 0, tsize-1 Do $
            wf[i, j, *] = sqrt(x[i]^2+y[j]^2+z^2)
          wf = cos(!pi*wf/(2.0*max(wf)))
          wf = wf > 0.0
        Endelse
      End
      3:Begin
        If(keyword_set(spherical)) Then Begin
          dx0 = x[1]-x[0]
          wf0 = dx0/[dx0, x[1:*]-x]
          wf0 = wf0 > 0.0
          For i = 0, rsize-1 Do wf[i, *, *] = wf0[i]
        Endif Else Begin
          dz0 = z[1]-z[0]
          wf0 = dz0/[dz0, z[1:*]-z]
          wf0 = wf0 > 0.0
          For k = 0, vsize-1 Do wf[*, *, k] = wf0[k]
        Endelse
      End
      4:Begin
        If(n_elements(dV) Eq 0) Then Begin
;Arrays for integration, need to be 3d to simplify loop structure
          dx = x[1:*]-x & dy = y[1:*]-y & dz = z[1:*]-z
          btyp = size(bx[0], /type)
          coeffx = 0.5*[dx[0], dx[0:rsize-3]+dx[1:rsize-2], dx[rsize-2]]
          coeffy = 0.5*[dy[0], dy[0:tsize-3]+dy[1:tsize-2], dy[tsize-2]]
          coeffz = 0.5*[dz[0], dz[0:vsize-3]+dz[1:vsize-2], dz[vsize-2]]
          If(keyword_set(spherical)) Then Begin
            coeffx = x^2*coeffx
            coeffy = sin(y)*coeffy
          Endif
          coeffxp3 = make_array(type = btyp, value = 0, rsize, tsize, vsize)
          coeffyp3 = coeffxp3
          coeffzp3 = coeffxp3
          For k = 0, vsize-1 Do Begin
            For i = 0, rsize-1 Do coeffyp3[i, *, k] = coeffy
            For j = 0, tsize-1 Do coeffxp3[*, j, k] = coeffx
          Endfor
          For i = 0, rsize-1 Do For j = 0, tsize-1 Do $
            coeffzp3[i, j, *] = coeffz
          dV = temporary(coeffxp3)*temporary(coeffyp3)*temporary(coeffzp3)
        Endif
        wf = min(dV)/dV
      End
    Endcase
  Endif

  Return
End

