;+
;NAME:
; vector_ops_fff
;PURPOSE:
; Calculates the div, curl, grad, and omega for bx, by, bz in the
; Bfields common block
;CALLING SEQUENCE:
; vector_ops_fff, x, y, z, dx, dy, dz
;INPUT:
; All in common blocks
; x, y, z = the spatial grid
; bx, by, bz = the B field, as contained in the common block bfields
;OUTPUT:
; fills the common block, Vectors,curl_bx, curl_by, curl_bz, div_b, $
;    omega_x, omega_y, omega_z 
;HISTORY:
; 18-feb-2004, jmm, jimm@ssl.berkeley.edu
; 17-feb-2005, jmm, Spherical q's, etc...
; 7-sep-2005, jmm, x,y,z are in the common block
; 10-sep-2005, jmm, replaced call to omega_fff, 
; 12-jul-2007, jmm, Added weighting function, wf
;-
Pro vector_ops_fff, _extra = _extra

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1, wf
  Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
    omega_x, omega_y, omega_z, omega2, b2
  curl_xyz, bx, by, bz, x, y, z, curl_bx, curl_by, curl_bz, /use_saved_grids, $
    _extra = _extra
  div_xyz, bx, by, bz, x, y, z, div_b, /use_saved_grids, $
    _extra = _extra

  cross_xyz, curl_bx, curl_by, curl_bz, bx, by, bz, omega_x, omega_y, omega_z
  b2 = (bx^2+by^2+bz^2)
  ok = where(b2 gt 0.0)
  If(ok[0] Eq -1) Then Begin
    message, /info, 'No nonzero B'
    Return
  Endif
  omega_x[ok] = (omega_x[ok] - div_b[ok]*bx[ok])/b2[ok]
  omega_y[ok] = (omega_y[ok] - div_b[ok]*by[ok])/b2[ok]
  omega_z[ok] = (omega_z[ok] - div_b[ok]*bz[ok])/b2[ok]
  omega2 = (omega_x^2+omega_y^2+omega_z^2)*wf
  omega_x = omega_x*wf
  omega_y = omega_y*wf
  omega_z = omega_z*wf
  Return
End
