;+
;rescales grids given a scale factor, for interpolation
Function temp_scale_grids, x_in, scale_factor
;-
  n = n_elements(x_in)
  nnew = ceil(float(n)/float(scale_factor))
  x0 = min(x_in)
  dx0 = (max(x_in)-x0)

  dx = dx0/float(nnew-1)
  x_out = x0+dx*findgen(nnew)

  Return, x_out
End
