;+
; Interpolates a 3d array onto a new z-grid
Function temp_interp_z, f, z, z_new
  sizf = size(f)
  If(sizf[0] Ne 3) Then Begin
    message, /info, 'Input Array must be 3-d'
    Return, -1
  Endif
  n = n_elements(z)
  nx = sizf[1] & ny = sizf[2] & nz = sizf[3]
  If(n ne nz) Then Begin
    message, /info, 'Mismatch between z and f[0,0,*]'
    Return, -1
  Endif
  nz_new = n_elements(z_new)
  otp = replicate(f[0], nx, ny, nz_new) & otp[*] = 0
  ix = value_locate(z, z_new)
  ix = ix > 0                   ;no -1's allowed
  ix = ix < (nz-2)              ;need 2 points to extrapolate
  a = (z_new-z[ix])/(z[ix+1]-z[ix])
  a = transpose(rebin(a, nz_new, ny, nx, /sample))
  otp = f[*, *, ix]*(1.0-a)+f[*, *, ix+1]*a
  Return, otp
End
  
