;+
;NAME:
;temp_interp_xyz
;PURPOSE:
;3-d interpolation, done in two steps, first 2d in the xy plane, then
;in the z direction, For the spherical case, with x,y,z -> r, theta,
;phi, the array is transposed and then this program is called
;recursively
;INPUT:
;f = a 3d array
;x,y,z = the coordinates for the f array
;xnew,ynew,znew = the new coordinates
;OUTPUT:
;g = f interpolated to the new coordinates
;KEYWORDS:
;spherical = if set, then use spherical coordinates, 
;            x,y,z -> r, theta, phi
;HISTORY:
;9-mar-2007, jmm, jimm@ssl.berkeley.edu
;-
Function temp_interp_xyz, f, x, y, z, xnew, ynew, znew, $
                          spherical = spherical, _extra = _extra

  If(keyword_set(spherical)) Then Begin
    g = transpose(f)
    g = temp_interp_xyz(temporary(g), z, y, x, znew, ynew, xnew)
    g = transpose(temporary(g))
  Endif Else Begin
    g = temp_interp_xy(f, x, y, xnew, ynew)
    g = temp_interp_z(temporary(g), z, znew)
  Endelse

  Return, g
End
