;+
; Interpolates a 3d array onto a new xy-grid
;-
Function temp_interp_xy, f, x, y, x_new, y_new
  sizf = size(f)
  If(sizf[0] Ne 3) Then Begin
    message, /info, 'Input Array must be 3-d'
    Return, -1
  Endif
  nx0 = n_elements(x)
  ny0 = n_elements(y)
  nx = sizf[1] & ny = sizf[2] & nz = sizf[3]
  If(nx0 Ne nx Or ny0 Ne ny) Then Begin
    message, /info, 'Mismatch between x, y,  and f[*,*,0]'
    Return, -1
  Endif
  nx_new = n_elements(x_new)
  ny_new = n_elements(y_new)
  otp = replicate(f[0], nx_new, ny_new, nz) & otp[*] = 0
  For j = 0, nz-1 Do otp[*, *, j] = interpu_2d(f[*, *, j], x, y, x_new, y_new)
  Return, otp
End
  
