;+
;NAME:
; rescale_1d_fff
;PURPOSE:
; rescales an array of N to (N/(scale_factor)+1) by rebinning, and
; then interpolating the rebinned data back to an array whic
; explicitly includes the end points.
;CALLING SEQUENCE:
; y_new = rescale_1d_fff(y, scale_factor, x_new, x_in=x_in)
;INPUT:
; y = an array
; scale_factor = the scale that you want to reduce by,n_elements(x)
;                must be an integer multiple of this.
;OUTPUT:
; y = an array of (n_elements(f)/scale_factor)+1 with the same values
;     at the end points as f
; x_new = the coordinates for the values of y
;KEYWORDS;
; x_in = an input coordinate system, the default is findgen(n_elements(y))
;HISTORY:
; 11-jan-2008, jmm, jimm@ssl.berkeley.edu
;-
Function rescale_1d_fff, y, scale_factor, x_new, x_in = x_in, _extra = _extra

  sc = long(scale_factor)
  ny = n_elements(y)
  If(keyword_set(x_in)) Then Begin
    If(n_elements(x_in) Eq ny) Then x = x_in Else x = findgen(ny)
  Endif Else x = findgen(ny)
  y_new = y & x_new = x
  If(ny mod sc Ne 0) Then Begin
    message, /info, 'No Rescaling done'
    Return, y_new
  Endif
  
  n1 = ny/sc
  y1 = rebin(y, n1)
  x1 = rebin(x, n1)
  
  nnew = n1+1
  x_new = x[0]+(x[ny-1]-x[0])*findgen(nnew)/float(n1)
  x_old = [x[0], x1, x[ny-1]]
  y_old = [y[0], y1, y[ny-1]]

  y_new = interpol(y_old, x_old, x_new)

  Return, y_new
End

  
    
