;+
;NAME:
; read_scalar_fff
;PURPOSE:
; Read in a scalar for the whole volume, e.g. read in divb or a
; weighting function
; Added use_sdf, 17-sep-2007, jmm
;-
Pro read_scalar_fff, file, rsize, tsize, vsize, wf
  openr, unit, file, /get_lun
  readf, unit, rsize, tsize, vsize
  rsize = long(rsize)
  tsize = long(tsize)
  vsize = long(vsize)
  wf = fltarr(rsize, tsize, vsize)
  readf, unit, wf
  free_lun, unit
  Return
End
