;OPTIMIZATION_FFF

;See the web page http://sprg.ssl.berkeley.edu/~jimm/fff/optimization_fff.html

;Some sample data has been included with the software in the test_data
;directory. The file "bfield_nlfff1.sav" contains an actual non-linear
;force free field created using the method of Low and Lou (1990, Apj
;352, 343.). Here is how you might use the field in this file to test
;to see how well the extrapolation works on a known field:

;restore, '$SSW/packages/nlfff/test_data/bfield_nlfff1.sav'
restore, 'bfield_nlfff1.sav'
help, bx0, by0, bz0                       ;these will be 64x64x64 arrays
optimization_fff, bx0, by0, bz0, $        ;The input is 3D
                  bc_flag = 1, $          ;This means that all BC's are present
                  /double, $              ;Double precision works better with test data, takes longer...
                  pr_iter = 10, $
                  convergence = 1.0e-6, $ ;the default value
                  iter = 500l

;(This command took 816 minutes on a 2 GHz processor pc, with 2
;Gbytes of RAM. But probably the calculation could have been cut off
;earlier, we don't have a good handle on how long to allow a test
;calculation to go before the answer is "good enough". Real magnetogram
;data, which is noisy, actually converges much more quickly.)

;Since the output file name is hardwired, you might want to move
;the output files. (Note -- The spawn commands are for a linux/unix
;system. I have no clue how to do this in windows or Mac. The
;extrapolation code should work for any operating system, though.)

spawn, '/bin/cp lhist.dat lhist__nlfff1.dat'      ;history file
spawn, '/bin/cp field.dat field__nlfff1.dat'      ;output field
spawn, '/bin/cp pfield.dat pfield__nlfff1.dat'    ;initial (potential) field

;Or you may want to save the output in a save file:

read_bfield_fff, 'field.dat', rsize, tsize, vsize, bx, by, bz, x, y, z

save, rsize, tsize, vsize, bx, by, bz, x, y, z, file = 'field__nlfff1.sav'

;Say that you want to test what happens in this case when you only
;put in the lower boundary:

;restore, '$SSW/packages/nlfff/test_data/bfield_nlfff1.sav'
restore, 'bfield_nlfff1.sav'
help, bx0, by0, bz0                       ;these will be 64x64x64 arrays
optimization_fff, bx0, by0, bz0, $        ;The input is 3D, but only z=0 field is used
                  bc_flag = 0, $          ;Only Lower BC's are present, (default)
                  /double, $              ;Double precision works better with test data, takes longer...
                  convergence = 1.0e-6, $ ;the default value
                  pr_iter = 10, $
                  iter = 500l ;The number of total iterations
;Fieldlines? 

;A program has been included for fieldline plotting. This is limited to
;cases for which all of the grids have uniform spacing. If you have
;your own fieldline-tracing program, use it.
;reading the data
read_bfield_fff, 'field.dat', rsize, tsize, vsize, bx, by, bz, x, y, z, /double
fieldlines_fff, bx, by, bz, ix, iy, x, y, z, /pick

;Use the /pick_lines keyword to choose field lines, and return ix,
;iy. If n_lines is set, then there will be this many lines, the default
;for n_lines is 20.
;You can change the view of the image by changing the angles:

fieldlines_fff, bx, by, bz, ix, iy, x, y, z, angx=45, angz=45


read_bfield_fff, 'pfield__nlfff1.dat', rsize, tsize, vsize, pbx, pby, pbz, x, y, z

fieldlines_fff, pbx, pby, pbz, ix, iy, x, y, z, angx=45, angz=45, $
  window_number = 2

;Yes, the fields do look different. 

;restore, '$SSW/packages/nlfff/test_data/bfield_nlfff1.sav'
restore, 'bfield_nlfff1.sav'
help, bx0, by0, bz0                       ;these will be 64x64x64 arrays
optimization_fff, bx0, by0, bz0, $        ;The input is 3D
                  bc_flag = 1, $          ;This means that all BC's are present
                  /double, $
                  pr_iter = 10, $
                  convergence = 1.0e-6, $ ;the default value
                  iter = 500l, /use_fortran, $
                  fortran_exe = 'f77/optimization_fff_f77.x'

;You can do all of this using the /use_sdf keyword, provided that you
;have sdf routines in your IDL path
;e.g, setenv IDL_PATH $IDL_PATH':'+/home/jimm/sdf-0.74/idl
;in your .cshrc, or in whateve IDL setup file you might use, 
;or add_path, '/home/jimm/sdf-0.74/idl' if you have SSW
restore, 'bfield_nlfff1.sav'
help, bx0, by0, bz0                       ;these will be 64x64x64 arrays
optimization_fff, bx0, by0, bz0, $        ;The input is 3D
                  bc_flag = 1, $          ;This means that all BC's are present
                  /double, $
                  pr_iter = 10, $
                  convergence = 1.0e-6, $ ;the default value
                  iter = 500l, /use_sdf
;and the output is in an sdf file:
read_bfield_fff, 'field.sdf', rsize, tsize, vsize, bx, by, bz, $
  x, y, z, /double, /use_sdf
fieldlines_fff, bx, by, bz, ix, iy, x, y, z, /pick


;Let's try the Dave version
restore, 'bfield_nlfff1.sav'
help, bx0, by0, bz0                       ;these will be 64x64x64 arrays
optimization_fff, bx0, by0, bz0, $        ;The input is 3D
                  bc_flag = 1, $          ;This means that all BC's are present
                  /double, $
                  pr_iter = 10, $
                  convergence = 1.0e-6, $ ;the default value
                  iter = 500l, /use_fortran, $
                  fortran_exe = 'f90/optimization_fff-trial.x'



End
