;+
;NAME:
; omega_fff
;PURPOSE:
; Used for FFF, see wheatland, etal, eqn 5
;CALLING SEQUENCE:
; omega_fff, bx, by, bz, curl_bx, curl_by, curl_bz, div_b, $
;        omega_x, omega_y, omega_z
;INPUT;
; bx, by, bz = B field
; curl_bx, curl_by, curl_bz = curl B
; div_b = divergence of B
;OUTPUT:
; omega_x, omega_y, omega_z = omega
; omega = (1/B^2)*((curlB X B) - (div_B)B)
;HISTORY:
; 30-aug-2000, jmm, jimm@ssl.berkeley.edu
; feb-2005, jmm, spherical q's, etc...
; 7-sep-2005, jmm, no longer pass out x0,oy0,oz0, added common blocks
;-
Pro Omega_fff, spherical = spherical,_extra = _extra
Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
  rsize, tsize, vsize, rsize1, tsize1, vsize1
Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
  omega_x, omega_y, omega_z
;ox0, oy0, and oz0 are the jXB terms
cross_xyz, curl_bx, curl_by, curl_bz, bx, by, bz, ox0, oy0, oz0
b2 = (bx^2+by^2+bz^2)
ok = where(b2 gt 0.0)
If(ok[0] Eq -1) Then Begin
    message, /info, 'No nonzero B'
    Return
Endif
omega_x = temporary(ox0)
omega_y = temporary(oy0)
omega_z = temporary(oz0)
omega_x[ok] = (omega_x[ok] - div_b[ok]*bx[ok])/b2[ok]
omega_y[ok] = (omega_y[ok] - div_b[ok]*by[ok])/b2[ok]
omega_z[ok] = (omega_z[ok] - div_b[ok]*bz[ok])/b2[ok]
delvarx, b2
Return
End

   
