;+
;NAME:
; obj_funct_fff
;PURPOSE:
; Calculates the objective function for the FFF code,
; See Wheatland, etal, 2000, eqn(5) Obj funct is
; the integral of b^2*Omega over the whole volume.
;CALLING SEQUENCE:
; L = obj_funct_fff(dx, dy, dz)
;INPUT:
; dx, dy, dz, the differentials of the spatial grid
; x, y, z = the spatial grid, held in the bfields common block
; bx, by, bz = the B field, held in the bfields common block
;OUTPUT:
; L = the integral of B^2*Omega^2 over the volume
;KEYWORDS:
; a = the JXB term
; b = the divb term
;HISTORY:
; 9-oct-2000, jmm
; switched to use common blocks for speed, 18-feb-2004, jmm
; Added Spherical coordinates, x -> r, y -> theta, z -> phi
; feb-2005, jmm
; Does the subtraction of the div_b term here, rather than in
; vector_ops_fff or omega_fff OOPS, I DON'T THINK SO...
;-
Function obj_funct_fff, dx, dy, dz, a = a, b = b, init_dv = init_dv, $
                        spherical = spherical, _extra = _extra

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1
  Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
    omega_x, omega_y, omega_z, omega2, b2
  Common Obj_funct_fff_private, dV

  If(n_elements(dV) Eq 0) Or (keyword_set(init_dv)) Then Begin
;Arrays for integration, need to be 3d to simplify loop structure
    btyp = size(bx[0], /type)
    coeffx = 0.5*[dx[0], dx[0:rsize-3]+dx[1:rsize-2], dx[rsize-2]]
    coeffy = 0.5*[dy[0], dy[0:tsize-3]+dy[1:tsize-2], dy[tsize-2]]
    coeffz = 0.5*[dz[0], dz[0:vsize-3]+dz[1:vsize-2], dz[vsize-2]]
    If(keyword_set(spherical)) Then Begin
      coeffx = x^2*coeffx
      coeffy = sin(y)*coeffy
    Endif
    coeffxp3 = make_array(type = btyp, value = 0, rsize, tsize, vsize)
    coeffyp3 = coeffxp3
    coeffzp3 = coeffxp3
    For k = 0, vsize1 Do Begin
      For i = 0, rsize1 Do coeffyp3[i, *, k] = coeffy
      For j = 0, tsize1 Do coeffxp3[*, j, k] = coeffx
    Endfor
    For i = 0, rsize1 Do For j = 0, tsize1 Do coeffzp3[i, j, *] = coeffz
    dV = temporary(coeffxp3)*temporary(coeffyp3)*temporary(coeffzp3)
  Endif
  ok = where(b2 gt 0.0)
  If(ok[0] Eq -1) Then Begin
    message, /info, 'No nonzero B'
    Return, -1
  Endif
  L = total(dV*b2*omega2)

Return, L
End
