;+
;NAME:
; lst_sq_alpha_fff
;PURPOSE:
; least-squares alpha value for linear fff calculation
;CALLING SEQUENCE:
; alpha = lst_sq_alpha(x, y, z)
;INPUT:
; x, y, z = spatial grid values
;In common block bfields:
; bx, by, bz = the reconstructed b field
;OUTPUT:
; alpha = the least squares alpha for the field, bx, by, bz
;HISTORY:
; 20-sep-2000, jmm
; Added rsize, for non-symmetric grids, to the common block, jmm,
; 17-feb-2005
; x,y,z are in the common block, jmm, 7-sep-2005
;-
Function lst_sq_alpha_fff
  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1
  tmp_bz = bz[*, *, 0]
  xxx = where(tmp_bz Eq 0)
  If(xxx[0] Ne -1) Then  tmp_bz[xxx] = 1.0e20
  loc_alph = (deriv_xy(x, by[*, *, 0], 1)-deriv_xy(y, bx[*, *, 0], 2))/tmp_bz 
  If(xxx[0] Ne -1) Then loc_alph[xxx] = 0.0
  sum = total(abs(bz[*, *, 0]))
  wsum = total(loc_alph*abs(bz[*, *, 0]))
  If(sum Eq 0) Then Return, 0.0 Else Return, wsum/sum
End
