function lin3interp,fgrid,xgrid,ygrid,zgrid,x,y,z

; Perform tri-linear interpolation on a function defined on a 3-d 
; cartesian grid (defined by the vectors xgrid,ygrid,zgrid - the grids 
; may be nonuniform), to return an estimate of the function value at 
; (x,y,z). Fixed typos, J Eq ny-1 instead of j Eq nx-1, jmm, 1-dec-2005

; produce grid spacing vectors

nx=n_elements(xgrid)
ny=n_elements(ygrid)
nz=n_elements(zgrid)

dx=xgrid(1:nx-1)-xgrid(0:nx-2)
dy=ygrid(1:ny-1)-ygrid(0:ny-2)
dz=zgrid(1:nz-1)-zgrid(0:nz-2)

; work out indices (i,j,k) of grid points just less than x,y,z

i=max(where(xgrid-x le 0))
j=max(where(ygrid-y le 0))
k=max(where(zgrid-z le 0))

; possible that (x,y,z) is outside box - in this case return 
; zero (a benign, although incorrect, value)

if ((i eq -1) or (j eq -1) or (k eq -1)) then f=0.0 else begin

    ; define nearby values - see notes. Cases here are required to
    ; catch `surface' points

    f0=fgrid(i,j,k)
    if (i eq nx-1) then f1=0 else f1=fgrid(i+1,j,k)
    if ((i eq nx-1) or (j eq ny-1)) then f2=0.0 else $
	f2=fgrid(i+1,j+1,k)
    if (j eq ny-1) then f3=0.0 else f3=fgrid(i,j+1,k)
    if ((j eq ny-1) or (k eq nz-1)) then f4=0.0 else $
	f4=fgrid(i,j+1,k+1)
    if (k eq nz-1) then f5=0.0 else f5=fgrid(i,j,k+1)
    if ((i eq nx-1) or (k eq nz-1)) then f6=0.0 else $
	f6=fgrid(i+1,j,k+1)
    if ((i eq nx-1) or (j eq ny-1) or (k eq nz-1)) then f7=0.0 else $
    f7=fgrid(i+1,j+1,k+1)

    ; produce coefficients ax,ay,az - see notes

    if (i eq nx-1) then ax=0.0 else ax=(x-xgrid(i))/dx(i)
    if (j eq ny-1) then ay=0.0 else ay=(y-ygrid(j))/dy(j)
    if (k eq nz-1) then az=0.0 else az=(z-zgrid(k))/dz(k)

    ; do the interpolation - see notes

    f=f0+ax*(f1-f0)+ay*(f3-f0)+az*(f5-f0)+ax*ay*(f2-f1-f3+f0)+$
        ax*az*(f6-f1-f5+f0)+ay*az*(f4-f3-f5+f0)+$
        ax*ay*az*(f7-f2-f6+f1-f4+f3+f5-f0)
endelse

return,f

end
