function lin2interp,fgrid,xgrid,ygrid,x,y

; Perform bi-linear interpolation on a function defined on a 2-d 
; cartesian grid (defined by the vectors xgrid,ygrid - the grids 
; may be nonuniform), to return an estimate of the function value at 
; (x,y). Fixed typo, J Eq ny-1 instead of j Eq nx-1, jmm, 1-dec-2005

; produce grid spacing vectors

nx=n_elements(xgrid)
ny=n_elements(ygrid)

dx=xgrid(1:nx-1)-xgrid(0:nx-2)
dy=ygrid(1:ny-1)-ygrid(0:ny-2)

; work out indices (i,j,k) of grid points just less than x,y,z

i=max(where(xgrid-x le 0))
j=max(where(ygrid-y le 0))

; possible that (x,y) is outside box - in this case return 
; zero (a benign, although incorrect, value)

if ((i eq -1) or (j eq -1)) then f=0.0 else begin

    ; define nearby values - see notes. Cases here are required to
    ; catch `surface' points

    f0=fgrid(i,j)
    if (i eq nx-1) then f1=0 else f1=fgrid(i+1,j)
    if ((i eq nx-1) or (j eq ny-1)) then f2=0.0 else $
	f2=fgrid(i+1,j+1)
    if (j eq ny-1) then f3=0.0 else f3=fgrid(i,j+1)

    ; produce coefficients ax,ay,az - see notes

    if (i eq nx-1) then ax=0.0 else ax=(x-xgrid(i))/dx(i)
    if (j eq ny-1) then ay=0.0 else ay=(y-ygrid(j))/dy(j)

    ; do the interpolation - see notes

    f=f0+ax*(f1-f0)+ay*(f3-f0)+ax*ay*(f2-f1-f3+f0)

endelse

return,f

end
