;+
;NAME:
; Initialb_fff
;PURPOSE:
; defines the starting B field for evolution
;CALLING SEQUENCE:
; initialb_fff, bc_flag
;INPUT:
; bc_flag = if set to 1, all of the boundaries are set,
;           if set to zero, only the lower boundary is set
;In common block bfields:
; pbx, pby, pbz = the poential field solution
; bx, by, bz = the reconstructed b field
;OUTPUT:
; bx, by, bz = the reconstructed b field
;KEYWORDS:
; taper_init_b= if set, taper the initial field with a function that
; decreases radially, as a power law
; f_taper=(r/taper_r0)^(-taper_index)beyond radiuses of taper_r0
; taper_r0= the default is 0.1, 
; taper_index= the default is 2.0
; fold_b0= if set, fold the field at the lower boundary into the
; initial field, this only can be used for bc_flag=0
; fold_frac=fraction of initial field included near boundary, the
; folded field varies as f_fold=fold_frac*(r/fold_r0)^(-fold_index)
; fold_index= the default is 1.0
; fold_r0= the default is 0.1 
; x, y, z = the grid arrays are needed to taper
;HISTORY:
; 20-sep-2000, jmm
; 20-aug-2001, jmm, added taper, deleted set_b0
; 18-feb-2004, jmm, dropped restart_flag, only call this if it isn't a
; restart, and tried to make less confusing
; jmm, 30-apr-2004 Added gray_middle option, in which the field inside
; the boundaries is initialized to a constant value, just to see if it
; works out.
; jmm, 17-feb-2005, all sorts of stuff involving spherical q's and
; non-symmetric x and y...
; jmm, 7-sep-2005, x,y,z are in the common block
;-

Pro Initialb_fff, bc_flag, taper_init_b = taper_init_b, $
                  taper_r0 = taper_r0, taper_index = taper_index, $
                  fold_b0 = fold_b0, $
                  fold_index = fold_index, fold_r0 = fold_r0, $
                  fold_frac = fold_frac, $
                  gray_middle = gray_middle, $
                  spherical = spherical, _extra = _extra


  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1

;Set to potential or linear FFF for z > 0, or r > r0
;If bc_flag=1, don't set the outer edges
  If(bc_flag Eq 1) Then Begin
    bx[1:rsize1-1, 1:tsize1-1, 1:vsize1-1] = $
      pbx[1:rsize1-1, 1:tsize1-1, 1:vsize1-1]
    by[1:rsize1-1, 1:tsize1-1, 1:vsize1-1] = $
      pby[1:rsize1-1, 1:tsize1-1, 1:vsize1-1]
    bz[1:rsize1-1, 1:tsize1-1, 1:vsize1-1] = $
      pbz[1:rsize1-1, 1:tsize1-1, 1:vsize1-1]
  Endif Else Begin
    If(keyword_set(spherical)) Then Begin
      bx[1:*, *, *] = pbx[1:*, *, *]
      by[1:*, *, *] = pby[1:*, *, *]
      bz[1:*, *, *] = pbz[1:*, *, *]
    Endif Else Begin
      bx[*, *, 1:*] = pbx[*, *, 1:*]
      by[*, *, 1:*] = pby[*, *, 1:*]
      bz[*, *, 1:*] = pbz[*, *, 1:*]
    Endelse
  Endelse
;Note that setting bc_flag =1 is kind of incompatible with all of the
;other options
  If(bc_flag Eq 1) Then Return
;Any tapering is done here
  If(keyword_set(taper_init_b)) Then Begin
    If(keyword_set(taper_r0)) Then r0 = taper_r0 Else r0 = 0.10
    If(keyword_set(taper_index)) Then index = taper_index $
    Else index = 2.0
    r = bx & r[*] = 0.0
    f = r+1.0
    If(keyword_set(spherical)) Then Begin
      For k = 0, vsize1 Do For j = 0, tsize1 Do r[*, j, k] = x - x[0]
    Endif Else Begin
      For k = 0, vsize1 Do For j = 0, tsize1 Do $
        r[*, j, k] = sqrt(x^2+y[j]^2+z[k]^2)
    Endelse
    ok =  where(r Ge r0)
    If(ok[0] Ne -1) Then f[ok] = (r0/r[ok])^index
    bx = bx*f
    by = by*f
    bz = bz*f
    delvarx, r, f
  Endif
;Any folding is done here
  If(keyword_set(fold_b0)) Then Begin
    If(keyword_set(fold_r0)) Then r0 = fold_r0 Else r0 = 0.10
    If(keyword_set(fold_index)) Then index = fold_index Else index = 1.0
    If(keyword_set(fold_frac)) Then ff0 = fold_frac Else ff0 = 1.0
    message, /info, 'folding Init B'
    r = bx & r[*] = 0.0
    f = r
    bx0 = f & by0 = f & bz0 = f
    If(keyword_set(spherical)) Then Begin
      For k = 0, vsize1 Do For j = 0, tsize1 Do r[*, j, k] = x - x[0]
      For i = 0, rsize1 Do Begin
        bx0[i, *, *] = bx[0, *, *]
        by0[i, *, *] = by[0, *, *]
        bz0[i, *, *] = bz[0, *, *]
      Endfor
    Endif Else Begin
      For k = 0, vsize1 Do Begin
        bx0[*, *, k] = bx[*, *, 0]
        by0[*, *, k] = by[*, *, 0]
        bz0[*, *, k] = bz[*, *, 0]
      Endfor
      For k = 0, vsize1 Do For j = 0, tsize1 Do $
        r[*, j, k] = sqrt(x^2+y[j]^2+z[k]^2)
    Endelse
    ok =  where(r Ge r0)
    f[*] = ff0
    If(ok[0] Ne -1) Then f[ok] = ff0*(r0/r[ok])^index
    bx = temporary(bx0)*f+bx*(1.0-f)
    by = temporary(by0)*f+by*(1.0-f)
    bz = temporary(bz0)*f+bz*(1.0-f)
    delvarx, r, f
  Endif
;Any gray_middling is done here
;new, randomize the initial field, to see what happens, jmm,
;9-jun-2004
  If(keyword_set(gray_middle)) Then Begin
    rrr = randomu(seed, tsize, tsize, vsize)-0.50
    b = sqrt(bx^2+by^2+bz^2)
    avb = total(b)/(rsize*tsize*vsize)
    bx[1:tsize-2, 1:tsize-2, 1:vsize-2] = $
      (avb/20.0)*rrr[1:tsize-2, 1:tsize-2, 1:vsize-2]
    by[1:tsize-2, 1:tsize-2, 1:vsize-2] = $
      (avb/20.0)*rrr[1:tsize-2, 1:tsize-2, 1:vsize-2]
    bz[1:tsize-2, 1:tsize-2, 1:vsize-2] = $
      (avb/20.0)*rrr[1:tsize-2, 1:tsize-2, 1:vsize-2]
    delvarx, rrr, b
  Endif
  Return
End
