;+
;NAME:
; gradient_xyz
;PURPOSE:
; Does the gradient for an array, using the DERIV routine,
; in Cartesian coordinates
;CALLING SEQUENCE:
; gradient_xyz, array, x, y, z, grad_x, grad_y, grad_z
;INPUT:
; array = a 3d array
; x, y, z, = the coordinates on which array is defined.
;OUTPUT:
; grad_x, grad_y, grad_z = the x, y, and z components of the the gradient
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
;-
PRO Gradient_xyz, a, x, y, z, grad_x, grad_y, grad_z

   grad_x = a
   grad_y = a
   grad_z = a
   siza = size(a)
   IF(siza[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF

   nx = N_ELEMENTS(x)
   IF(Nx NE siza[1]) THEN BEGIN
      message, /info, 'Bad X array'
      RETURN
   ENDIF
   ny = N_ELEMENTS(y)
   IF(Ny NE siza[2]) THEN BEGIN
      message, /info, 'Bad Y array'
      RETURN
   ENDIF
   nz = N_ELEMENTS(z)
   IF(Nz NE siza[3]) THEN BEGIN
      message, /info, 'Bad Z array'
      RETURN
   ENDIF

;X  & y Gradients
   FOR k = 0, nz-1 DO BEGIN
      FOR j = 0, ny-1 DO grad_x[*, j, k] = deriv(x, a[*, j, k])
      FOR i = 0, nx-1 DO grad_y[i, *, k] = deriv(y, reform(a[i, *, k]))
   ENDFOR
;Z Gradient
   FOR j = 0, ny-1 DO FOR i = 0, nx-1 DO $
     grad_z[i, j, *] = deriv(z, reform(a[i, j, *]))

   RETURN
END

