;+
;NAME:
; grad_rtp
;PURPOSE:
; Does the gradient for an array, using the DERIV routine,
; in Cartesian coordinates
;CALLING SEQUENCE:
; grad_rtp, array, x, y, z, grad_x, grad_y, grad_z
;INPUT:
; array = a 3d array
; x, y, z, = the coordinates on which array is defined.
;OUTPUT:
; grad_x, grad_y, grad_z = the x, y, and z components of the the gradient
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
; switched to use deriv_dx, _dy, and _dz, 
; 1-apr-2003, jmm, Added _extra
; 21-jan-2004, jmm, spherical q's, x -> r, y -> theta, z -> phi
;-
PRO Grad_rtp, a, x, y, z, grad_x, grad_y, grad_z, $
              use_saved_grids = use_saved_grids, _extra = _extra

   Common saved_rtp, rx, sintheta
   grad_x = a
   grad_y = a
   grad_z = a
   siza = size(a)
   IF(siza[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF

   nx = N_ELEMENTS(x)
   IF(Nx NE siza[1]) THEN BEGIN
      message, /info, 'Bad X array'
      RETURN
   ENDIF
   ny = N_ELEMENTS(y)
   IF(Ny NE siza[2]) THEN BEGIN
      message, /info, 'Bad Y array'
      RETURN
   ENDIF
   nz = N_ELEMENTS(z)
   IF(Nz NE siza[3]) THEN BEGIN
      message, /info, 'Bad Z array'
      RETURN
   ENDIF

   If(n_elements(rx) Eq 0 Or (Not keyword_set(use_saved_grids))) Then Begin
       rx = rebin(x, nx, ny, nz)
       sintheta = rebin(sin(y), ny, nz, nx)
       sintheta = transpose(sintheta, [2, 0, 1])
   Endif
;Gradients
   grad_x = deriv_dx(x, a, _extra = _extra)
   grad_y = deriv_dy(y, a, _extra = _extra)/rx
   grad_z = deriv_dz(z, a, _extra = _extra)/(rx*sintheta)

   RETURN
END

