;+
;NAME:
; force_fff
;PURPOSE:
; Used for FFF, see wheatland, etal, eqn 5
;CALLING SEQUENCE:
; force_fff, x, y, z, bx, by, bz, curl_bx, curl_by, curl_bz, div_b, $
;        omega_x, omega_y, omega_z, f_x, f_y, f_z
;INPUT;
; x, y, z = the grid
; In common blocks:
; bx, by, bz = B field
; curl_bx, curl_by, curl_bz = curl B
; div_b = divergence of B
; omega_x, omega_y, omega_z = omega
; omega = (1/B^2)*((curlB X B) - (div_B)B)
;OUTPUT:
; f_x, f_y, f_z = force_fff
; See eqn 7 of Wheatland, etal.
;HISTORY:
; 30-aug-2000, jmm, jimm@ssl.berkeley.edu
; 18-feb-2004, jmm, added common blocks
; 17-feb-2005, jmm, spherical q's, and  non-symmetric tsize
;-
PRO Force_fff, f_x, f_y, f_z, _extra = _extra

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1
  Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
    omega_x, omega_y, omega_z, omega2, b2
 
;First curl of omega cross b
  cross_xyz, omega_x, omega_y, omega_z, bx, by, bz, temp_x, temp_y, temp_z
  curl_xyz, temporary(temp_x), temporary(temp_y), temporary(temp_z), $
    x, y, z, f_x, f_y, f_z, _extra = _extra
;Next subtract omega cross curl B
  cross_xyz, omega_x, omega_y, omega_z, curl_bx, curl_by, curl_bz, $
    temp_x, temp_y, temp_z
  f_x = f_x - temporary(temp_x)
  f_y = f_y - temporary(temp_y)
  f_z = f_z - temporary(temp_z)
;Next subtract grad omega dot B
  temp = dot_xyz(omega_x, omega_y, omega_z, bx, by, bz)
  grad_xyz, temp, x, y, z, temp_x, temp_y, temp_z
  f_x = f_x - temporary(temp_x)
  f_y = f_y - temporary(temp_y)
  f_z = f_z - temporary(temp_z)
;Add omega times div_b   
  f_x = f_x + omega_x*div_b
  f_y = f_y + omega_y*div_b
  f_z = f_z + omega_z*div_b
;Add omega^2 times B
  f_x = f_x + omega2*bx
  f_y = f_y + omega2*by
  f_z = f_z + omega2*bz
  Return
End

   
