MODULE vars
  USE params
  IMPLICIT NONE
  SAVE

  ! Input data
  INTEGER(KIND=i4) :: nx, ny, nz
  REAL(KIND=r8), DIMENSION(:), ALLOCATABLE :: x, y, z
  REAL(KIND=r8), DIMENSION(:,:,:), ALLOCATABLE :: bx, by, bz, wf

  ! Input parameters
  LOGICAL :: qsphere, slow, conv_flag
  INTEGER(KIND=i4) :: imax
  REAL(KIND=r8) :: dt, abs_frac_diff, alpha, bzmax, local_l

  ! Useful variables
  INTEGER(KIND=i4) :: ferror
  ! Integration coefficients
  REAL(KIND=r8), DIMENSION(:), ALLOCATABLE :: xint_coeff
  REAL(KIND=r8), DIMENSION(:), ALLOCATABLE :: yint_coeff
  REAL(KIND=r8), DIMENSION(:), ALLOCATABLE :: zint_coeff
  ! Derivative coefficients
  REAL(KIND=r8), DIMENSION(:,:), ALLOCATABLE :: xder_coeff
  REAL(KIND=r8), DIMENSION(:,:), ALLOCATABLE :: yder_coeff
  REAL(KIND=r8), DIMENSION(:,:), ALLOCATABLE :: zder_coeff

END MODULE vars
