;+
;NAME:
; evolve_fff
;PURPOSE:
; Eveloves the magnetc field for 1 time step
;CALLING SEQUENCE:
; evolve_fff, x, y, z, dt, l_value, local_l
;INPUT:
; x, y, z, = the spatial grid
; dx, dy, dz = the differentials of the spatial grid
; dt = step size in "Time" t
; l_value = the value of the objective function, before iteration
;In common block bfields:
; bx, by, bz = the b field
;OUTPUT:
; local_l = final value of l_value
; convergence_flag = set to 1 if not converging..
;In common block bfields:
; bx, by, bz = the evolved b field
;HISTORY:
; 9-oct-2000, jmm, jimm@ssl.berkeley.edu
; 31-jul-2001, jmm, Added abs_frac_diff keyword for convergence 
; 18-feb-2004, jmm, Uses common blocks, the idea is to only have to do
; curl, div once per iteration
; 14-jun-2004, flag_day, Added calc_dt keyword
; 17-feb-2005, jmm, spherical q's, and  non-symmetric tsize
;-
PRO Evolve_fff, dx, dy, dz, dt, l_value, local_l, $
                convergence_flag, abs_frac_diff = abs_frac_diff, $
                _extra = _extra

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1
  Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
    omega_x, omega_y, omega_z, omega2, b2

  IF(keyword_set(abs_frac_diff)) THEN afd = abs_frac_diff ELSE afd = 1.0e-6
  rsize2 = rsize-2
  tsize2 = tsize-2
  vsize2 = vsize-2
;save initial values, but only for bx, by, and bz
  tbx = bx & tby = by & tbz = bz
;evolution of volume field - boundary values are not changed -- Get dBdt
  force_fff, dbdt_x, dbdt_y, dbdt_z, _extra = _extra
  localdt = dt                  ;ok
  done = 0b
  While((localdt Gt dt/10000.0) And (Not done)) Do Begin
    bx[1:rsize2, 1:tsize2, 1:vsize2] = $
      bx[1:rsize2, 1:tsize2, 1:vsize2]+$
      dBdt_x[1:rsize2, 1:tsize2, 1:vsize2]*localdt
    by[1:rsize2, 1:tsize2, 1:vsize2] = $
      by[1:rsize2, 1:tsize2, 1:vsize2]+$
      dBdt_y[1:rsize2, 1:tsize2, 1:vsize2]*localdt
    bz[1:rsize2, 1:tsize2, 1:vsize2] = $
      bz[1:rsize2, 1:tsize2, 1:vsize2]+$
      dBdt_z[1:rsize2, 1:tsize2, 1:vsize2]*localdt
;Not on the boundaries
;Get curls, div, omega , and evaluate objective function for evolved field
    vector_ops_fff, _extra = _extra
    local_l = obj_funct_fff(dx, dy, dz, _extra = _extra)
;Check for convergence
    frac_diff = abs((local_l-l_value)/l_value)
    If(frac_diff Lt afd) Then Begin
      message, /info, 'Converged; frac_diff ='+strtrim(string(frac_diff), 2)
      done = 1b
      convergence_flag = 1b
      dt = localdt
      delvarx, tbx, tby, tbz
      Return                    ;all done, bye-bye
    Endif
    If(local_l Lt l_value) Then Begin
      done = 1b
      localdt = localdt*1.01 ;suggestion by T Wiegelmann, 17-may-2005, jmm
    Endif Else Begin
;If l has not decreased, restore initial values, otherwise keep new values
      bx = tbx & by = tby & bz = tbz
      vector_ops_fff, _extra = _extra
;hmm, reduce timestep, try again if the same or bigger
      If(localdt Gt dt/10000.0) Then Begin
        done = 0b
        localdt = localdt/2.0
        message, /info, 'Reducing dt to '+strtrim(string(localdt), 2)
      Endif Else Begin
        done = 1b
      Endelse
    Endelse
  Endwhile
;update field, objective function value if decreased
  If(localdt Le dt/10000.0) Then Begin
    convergence_flag = 1b
    message, /info, 'NOT converging'
  Endif Else convergence_flag = 0b
  dt = localdt
  delvarx, tbx, tby, tbz
  Return
End
