;+
;NAME:
; dot_xyz
;PURPOSE:
; Does the dot product for two 3d vectors
; in Cartesian coordinates
;CALLING SEQUENCE:
; product = dot_xyz(ax, ay, az, bx, by, bz)
;INPUT:
; ax, ay, az, bx, by, bz = are 3d arrays defined on (x,y,z)
;OUTPUT:
; product = a dot b
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
;-
function dot_xyz, ax, ay, az, bx, by, bz

   sizax = size(ax)
   IF(sizax[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   sizay = size(ay)
   IF(sizay[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   sizaz = size(az)
   IF(sizaz[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   IF(total(sizax[0:3]) NE total(sizay[0:3]) OR $
      total(sizax[0:3]) NE total(sizaz[0:3])) THEN BEGIN
      message, /info, 'Arrays have mismatched sizes'
      RETURN, -1
   ENDIF
   sizbx = size(bx)
   IF(sizbx[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   sizby = size(by)
   IF(sizby[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   sizbz = size(bz)
   IF(sizbz[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, -1
   ENDIF
   IF(total(sizbx[0:3]) NE total(sizby[0:3]) OR $
      total(sizbx[0:3]) NE total(sizbz[0:3])) THEN BEGIN
      message, /info, 'Arrays have mismatched sizes'
      RETURN, -1
   ENDIF
   
   product = ax*bx+ay*by+az*bz
   
   RETURN, product
END

