function zderiv_fd3d, f, dz, z1d=z1d, zper=zper

; Assumes uniform grid, & strives for second order accuracy. 
; Default assumes no periodicity.
;
; Non-periodic derivs mimic IDL's DERIV.PRO at end points, e.g.,
;  f'(0) =     f'(0.5)      - 0.5*     f"(1)          *dz
; Sign of f" term flips at other end point.
;
; LEFT:  = [f(   1) - f(   0)]/dz - 0.5*[f(   0) - 2*f(   1) + f(   2)]/dz
;        = [-1.5*f(   0) + 2*f(   1) - 0.5*f(   2)]/dz      
;
; RIGHT  = [f(nz-1) - f(nz-2)]/dz + 0.5*[f(nz-3) - 2*f(nz-2) + f(nz-1)]/dz
;        = [ 0.5*f(nz-3) - 2*f(nz-2) + 1.5*f(nz-1)]/dz      
;


if not(keyword_set(dz)) then dz = 1.

dims = size(f, /dim)
nx = dims(0)	; define dimensionality
ny = dims(1)
nz = dims(2)

z1d = findgen(nz)*dz

; define arrays
dfdz = fltarr(nx,ny,nz)  	; this will be output array

; Periodic in Z, or not?
if not(keyword_set(zper)) then begin ; Not periodic in Z
    dfdz(*,*,0     ) =  0.5*( -f(*,*,   2) + 4*f(*,*,   1) - 3*f(*,*,   0))/dz
    dfdz(*,*,1:nz-2) =  0.5*(f(*,*,2:nz-1) -   f(*,*,0:nz-3))/dz
    dfdz(*,*,  nz-1) =  0.5*(3*f(*,*,nz-1) - 4*f(*,*,nz-2) +   f(*,*,nz-3))/dz 
endif else dfdz = 0.5*(shift(f,[0,0,-1]) - shift(f,[0,0,1]))/dz ; PERIODIC

return, dfdz

end
