function yderiv_fd3d, f, dy, y1d=y1d, yper=yper

; Assumes uniform grid, & strives for second order accuracy. 
; Default assumes no periodicity.
;
; Non-periodic derivs mimic IDL's DERIV.PRO at end points, e.g.,
;  f'(0) =     f'(0.5)      - 0.5*     f"(1)          *dy
; Sign of f" term flips at other end point.
;
; LEFT:  = [f(   1) - f(   0)]/dy - 0.5*[f(   0) - 2*f(   1) + f(   2)]/dy
;        = [-1.5*f(   0) + 2*f(   1) - 0.5*f(   2)]/dy      
;
; RIGHT  = [f(ny-1) - f(ny-2)]/dy + 0.5*[f(ny-3) - 2*f(ny-2) + f(ny-1)]/dy
;        = [ 0.5*f(ny-3) - 2*f(ny-2) + 1.5*f(ny-1)]/dy      

if not(keyword_set(dy)) then dy = 1.

dims = size(f, /dim)
nx = dims(0)	; define dimensionality
ny = dims(1)
nz = dims(2)

y1d = findgen(ny)*dy

; define arrays
dfdy = fltarr(nx,ny,nz)  	; this will be output array

; Periodic in Y, or not?
if not(keyword_set(yper)) then begin ; Not periodic in Y
    dfdy(*,0     ,*) = -0.5*(  f(*,   2,*) - 4*f(*,   1,*) + 3*f(*,   0,*))/dy
    dfdy(*,1:ny-2,*) =  0.5*(f(*,2:ny-1,*)-f(*,0:ny-3,*))/dy
    dfdy(*,  ny-1,*) =  0.5*(3*f(*,ny-1,*) - 4*f(*,ny-2,*) +   f(*,ny-3,*))/dy 
endif else dfdy = 0.5*(shift(f,[0,-1,0]) - shift(f,[0,1,0]))/dy ; PERIODIC

return, dfdy

end
