function yderiv_fd, infield, dx, y1d

; This subroutine uses IDL's DERIV.PRO to compute the 
; the 2D y-derivative of the 2D input array.
; Optionally returns 1D array of y-coordinate.

if not(keyword_set(dx)) then dx = 1.

dims = size(infield, /dim)
nx = dims(0)	; define dimensionality
ny = dims(1)

y1d = findgen(ny)*dx

; define arrays
outfield = fltarr(nx,ny)  	; this will be output array

for j=0.,nx-1. do outfield(j,*) = deriv(y1d,infield(j,*))

return, outfield

end
