function xderiv_fd3d, f, dx, x1d=x1d, xper=xper

; Assumes uniform grid, & strives for second order accuracy. 
; Default assumes no periodicity.
;
; Non-periodic derivs mimic IDL's DERIV.PRO at end points, e.g.,
;  f'(0) =     f'(0.5)      - 0.5*     f"(1)          *dx
; Sign of f" term flips at other end point.
;
; LEFT:  = [f(   1) - f(   0)]/dx - 0.5*[f(   0) - 2*f(   1) + f(   2)]/dx
;        = [-1.5*f(   0) + 2*f(   1) - 0.5*f(   2)]/dx      
;
; RIGHT  = [f(nx-1) - f(nx-2)]/dx + 0.5*[f(nx-3) - 2*f(nx-2) + f(nx-1)]/dx
;        = [ 0.5*f(nx-3) - 2*f(nx-2) + 1.5*f(nx-1)]/dx      

if not(keyword_set(dx)) then dx = 1.

dims = size(f, /dim)
nx = dims(0)	; define dimensionality
ny = dims(1)
nz = dims(2)

x1d = findgen(nx)*dx

; define arrays
dfdx = fltarr(nx,ny,nz)  	; this will be output array

; Periodic in X, or not?
if not(keyword_set(xper)) then begin ; Not periodic in X
    dfdx(0     ,*,*) = -0.5*(  f(   2,*,*) - 4*f(   1,*,*) + 3*f(   0,*,*))/dx
    dfdx(1:nx-2,*,*) =  0.5*(f(2:nx-1,*,*)-f(0:nx-3,*,*))/dx
    dfdx(  nx-1,*,*) =  0.5*(3*f(nx-1,*,*) - 4*f(nx-2,*,*) +   f(nx-3,*,*))/dx
endif else dfdx = 0.5*(shift(f,[-1,0,0]) - shift(f,[1,0,0]))/dx ; PERIODIC

return, dfdx

end
