function xderiv_fd, infield, dx, x1d

; This subroutine uses IDL's DERIV.PRO to compute the 
; the 2D x-derivative of the 2D input array.
; Optionally returns 1D array of x-coordinate.

if not(keyword_set(dx)) then dx = 1.

dims = size(infield, /dim)
nx = dims(0)	; define dimensionality
ny = dims(1)

x1d = findgen(nx)*dx

; define arrays
outfield = fltarr(nx,ny)  	; this will be output array

for j=0.,ny-1. do outfield(*,j) = deriv(x1d,infield(*,j))

return, outfield

end
