pro div_check, bx, by, bz, divb, verbose=verbose, dx=dx

if not(keyword_set(dx)) then dx = 1.

nx = n_elements(bx(*,0,0)) 
ny = n_elements(bx(0,*,0)) 
nz = n_elements(bx(0,0,*)) 

divb = fltarr(nx,ny,nz)

if keyword_set(verbose) then begin

    ; get these functions compiled now, so announcements won't hose listing
    crap = max(abs(bx))
    crap = mean(abs(bx))
    crap = median(abs(bx))

    print,'z, max, mean, & median |div(B)|,'+ $
      ' mean & median |dB_i/dx_i|, & (x,y) coords of max |div(B)|:'

endif

for i = 0,nz-1 do begin

    bxi = bx(*,*,i)
    byi = by(*,*,i)
    bzi = bz(*,*,i)

    dbx_dx = xderiv_fd(bxi, dx)
    dby_dy = yderiv_fd(byi, dx)

    case 1 of 
        (i gt 0 and i lt nz-1): dbz_dz = $
          (   bz(*,*, i+1)                  - bz(*,*, i-1))/(2.*dx)

        (i eq 0): dbz_dz = $
          (-3*bz(*,*,   0) + 4*bz(*,*,   1) - bz(*,*,   2))/(2.*dx)

        (i eq nz-1): dbz_dz = $
          ( 3*bz(*,*,nz-1) - 4*bz(*,*,nz-2) + bz(*,*,nz-3))/(2.*dx)
    endcase

    divbi = dbx_dx + dby_dy + dbz_dz

    divb(*,*,i) = divbi

    if keyword_set(verbose) then begin
        refdiv = sqrt(dbx_dx^2 + dby_dy^2 + dbz_dz^2) 
    
        print,i,max(abs(divbi),divmax),mean(abs(divbi)),median(abs(divbi)), $
          mean(refdiv),median(refdiv),(divmax)mod(nx),floor(divmax/float(nx))
    
    endif

endfor


end

