;+
;NAME:
; div_xyz
;PURPOSE:
; Does the divergence for a 3d vector, using the DERIV routine,
; in Cartesian coordinates
;CALLING SEQUENCE:
; div_xyz, ax, ay, az, x, y, z, div_a
;INPUT:
; ax, ay, az = are 3d arrays defined on (x,y,z)
; x, y, z, = the coordinates on which the arrays is defined.
;OUTPUT:
; div_a = the divergence of a
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
; switched to use deriv_dx, _dy, and _dz, 
; Added _extra, 1-apr-2003, jmm
; 29-dec-2004, jmm, added spherical keyword, if this is set, 
;              call div_rtp.pro
;-
PRO div_xyz, ax, ay, az, x, y, z, div_a, $
             spherical = spherical, _extra = _extra

   IF(keyword_set(spherical)) THEN BEGIN ;spherical q's
       div_rtp, ax, ay, az, x, y, z, div_a, _extra=_extra
       RETURN
   ENDIF
   sizax = size(ax)
   IF(sizax[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizay = size(ay)
   IF(sizay[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizaz = size(az)
   IF(sizaz[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   IF(total(sizax[0:3]) NE total(sizay[0:3]) OR $
      total(sizax[0:3]) NE total(sizaz[0:3])) THEN BEGIN
      message, /info, 'Arrays have mismatched sizes'
      RETURN
   ENDIF
   
   nx = N_ELEMENTS(x)
   IF(Nx NE sizax[1]) THEN BEGIN
      message, /info, 'Bad X array'
      RETURN
   ENDIF
   ny = N_ELEMENTS(y)
   IF(Ny NE sizax[2]) THEN BEGIN
      message, /info, 'Bad Y array'
      RETURN
   ENDIF
   nz = N_ELEMENTS(z)
   IF(Nz NE sizax[3]) THEN BEGIN
      message, /info, 'Bad Z array'
      RETURN
   ENDIF

   daxdx = deriv_dx(x, ax, _extra = _extra)
   daydy = deriv_dy(y, ay, _extra = _extra)
   dazdz = deriv_dz(z, az, _extra = _extra)

   div_a = daxdx+daydy+dazdz

   RETURN
END

