;+
;NAME:
; discrepancy_fff
;PURPOSE:
; calculate elements of divergence arrays, magnitude-of-curl
; array, magnitude-of-force array, current-weighted average
; of sine of angle between J and B 
;CALLING SEQUENCE:
; discrepancy_fff, bzmax, bx, by, bz, x, y, z, thetaj, theta, f, force
;INPUT:
; bzmax = max value of bz
; bx, by, bz = B field
; x, y, z = the spatial grid
;OUTPUT:
; thetaj =
; theta =
; f =
; force =
;HISTORY:
; 16-oct-2000, jmm, jimm@ssl.berkeley.edu
; 17-feb-2005, jmm, Gutted, no longer prints, and uses the values in
; vector_ops_fff to get the results. Saves time...
;-
PRO Discrepancy_fff, thetaj, theta, f, force

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1
  Common Vectors, curl_bx, curl_by, curl_bz, div_b, $
    omega_x, omega_y, omega_z, omega2, b2

  magcurlb = sqrt(curl_bx^2+curl_by^2+curl_bz^2)
;ox0, oy0, and oz0 are the jXB terms
  cross_xyz, curl_bx, curl_by, curl_bz, bx, by, bz, ox0, oy0, oz0
  magforce = sqrt(ox0^2+oy0^2+oz0^2)
;current-weighted angle
  magb = sqrt(b2)
  ok = where(b2 Gt 0 And magcurlb Gt 0)
  If(ok[0] Eq -1) Then Begin
    message, /info, 'B is all 0 Or J is all 0'
    return
  Endif
;be careful with 0's
  temp = magforce & temp[*] = 0
  temp[ok] = magforce[ok]/magb[ok]
  num = total(temp)
  den = total(magcurlb[ok])
;sums for average angle, divergence
  temp[*] = 0.0
  temp[ok] = magforce[ok]/(magcurlb[ok]*magb[ok])
  temp = temp < 1.0             ;careful
  thetasum = total((180.0/!Pi)*asin(temp))
  delvarx, temp
  divsum = total(abs(div_b))
  forcesum = total(magforce)
  thetaj = asin(num/den)*180.0/!PI
  npts = 1.0*rsize1*tsize1*vsize1
  theta = thetasum/npts
  f = divsum/npts
  force = forcesum/npts
  Return
End
