; differential.pro - return rhs of ode's

function differential2,s,coords

common shared, bx,by,bz,x,y,z,x2,y2,z2,sign

bxinterp=lin3interp(bx,x2,y2,z2,coords(0),coords(1),coords(2))
byinterp=lin3interp(by,x2,y2,z2,coords(0),coords(1),coords(2))
bzinterp=lin3interp(bz,x2,y2,z2,coords(0),coords(1),coords(2))

binterp=sqrt(bxinterp^2+byinterp^2+bzinterp^2)

if (binterp eq 0.0) then result=[0.0,0.0,0.0] else $
    result=sign*[bxinterp/binterp,byinterp/binterp,bzinterp/binterp]

return,result

end

