;+
;NAME:
; deriv_xyz0
;PURPOSE:
; A partial derivative, using the IDL DERIV routine
;CALLING SEQUENCE:
; dfdq = deriv_xyz0(q, f, index)
; index = 1 for an x derivative, 2 for y, 3 for z
;INPUT:
; f = a 3d array
; q = x, y, or z, = the coordinates on which array is defined.
;OUTPUT:
; dfdq = the partial derivative in the give direction for the given function
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
;-
FUNCTION deriv_xyz0, q, f, Index

   dfdq = f & dfdq[*] = 0
   sizf = size(f)
   IF(sizf[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN, dfdq
   ENDIF
   nx = sizf[1] & ny = sizf[2] & nz = sizf[3]

   nq = N_ELEMENTS(q)
   IF(Nq NE sizf[index]) THEN BEGIN
      message, /info, 'Bad Coordinate array'
      RETURN, dfdq
   ENDIF

   CASE index OF
      1: FOR k = 0, nz-1 DO FOR j = 0, ny-1 DO $
        dfdq[*, j, k] = deriv(q, f[*, j, k])
      2: FOR k = 0, nz-1 DO FOR i = 0, nx-1 DO $
        dfdq[i, *, k] = deriv(q, reform(f[i, *, k]))
      3: FOR j = 0, ny-1 DO FOR i = 0, nx-1 DO $
        dfdq[i, j, *] = deriv(q, reform(f[i, j, *]))
      ELSE: message, /info, 'Bad Index passed in'
   ENDCASE
   RETURN, dfdq
END

