;+
;NAME:
; deriv_xy
;PURPOSE:
; A partial derivative, using the IDL DERIV routine
;CALLING SEQUENCE:
; dfdq = deriv_xy(q, f, index)
; index = 1 for an x derivative, 2 for y
;INPUT:
; f = a 2d array
; q = x, or y = the coordinates on which array is defined.
;OUTPUT:
; dfdq = the partial derivative in the give direction for the given function
;HISTORY:
; 20-sep-2000, jmm, jimm@ssl.berkeley.edu
;-
FUNCTION Deriv_xy, q, f, Index

   dfdq = f & dfdq[*] = 0
   sizf = size(f)
   IF(sizf[0] NE 2) THEN BEGIN
      message, /info, 'Array must be 2-d'
      RETURN, dfdq
   ENDIF
   nx = sizf[1] & ny = sizf[2]

   nq = N_ELEMENTS(q)
   IF(Nq NE sizf[index]) THEN BEGIN
      message, /info, 'Bad Coordinate array'
      RETURN, dfdq
   ENDIF

   CASE index OF
      1: FOR j = 0, ny-1 DO $
        dfdq[*, j] = deriv(q, f[*, j])
      2: FOR i = 0, nx-1 DO $
        dfdq[i, *] = deriv(q, reform(f[i, *]))
      ELSE: message, /info, 'Bad Index passed in'
   ENDCASE
   RETURN, dfdq
END

