;+
;NAME:
; cross_xyz
;PURPOSE:
; Does the cross product for two 3d vectors
; in Cartesian coordinates
;CALLING SEQUENCE:
; cross_xyz, ax, ay, az, bx, by, bz, cx, cy, cz
;INPUT:
; ax, ay, az, bx, by, bz = are 3d arrays defined on (x,y,z)
;OUTPUT:
; cx, cy, cz = a cross b
;HISTORY:
; 18-aug-2000, jmm, jimm@ssl.berkeley.edu
;-
PRO cross_xyz, ax, ay, az, bx, by, bz, cx, cy, cz

   sizax = size(ax)
   IF(sizax[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizay = size(ay)
   IF(sizay[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizaz = size(az)
   IF(sizaz[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   IF(total(sizax[0:3]) NE total(sizay[0:3]) OR $
      total(sizax[0:3]) NE total(sizaz[0:3])) THEN BEGIN
      message, /info, 'Arrays have mismatched sizes'
      RETURN
   ENDIF
   sizbx = size(bx)
   IF(sizbx[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizby = size(by)
   IF(sizby[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   sizbz = size(bz)
   IF(sizbz[0] NE 3) THEN BEGIN
      message, /info, 'Array must be 3-d'
      RETURN
   ENDIF
   IF(total(sizbx[0:3]) NE total(sizby[0:3]) OR $
      total(sizbx[0:3]) NE total(sizbz[0:3])) THEN BEGIN
      message, /info, 'Arrays have mismatched sizes'
      RETURN
   ENDIF
   
   cx = ay*bz - az*by
   cy = az*bx - ax*bz
   cz = ax*by - ay*bx
   
   RETURN
END

