;+
; Wrapper around Tom Metcalf's fff.pro
; If bz_only is set, then only reset the lower boundary field bz to
; the input bz, bx_ and by are unchanged. This may bomb for rsize NE
; tsize...
Pro call_tomm_fff, alpha, _extra = _extra
;-

  Common Bfields, bx, by, bz, pbx, pby, pbz, x, y, z, $
    rsize, tsize, vsize, rsize1, tsize1, vsize1

; The fff routine uses real units...
  au = 1.495979d8
  l_arcsec = au/(!radeg*3600.0)
  pix_size = 5.7*l_arcsec/1000.0 ;units of Mm are needed
  ht = (tsize-1)*pix_size
  z_in = z*ht

  bff = fff(bz[*, *, 0], alpha = alpha, b0 = 0, pangle = 0, $
            lat = 0, cmd = 0, z = z_in, /normal, guard = 2, /flux_balance)
  pbx = double(bff[*, *, *, 0])
  pby = double(bff[*, *, *, 1])
  pbz = double(bff[*, *, *, 2])
  delvarx, bff
  Return
End
