;+
; Uses wdefroi to get a box, then mult_fieldlines_fff to draw all of
; the lines out of that box.
Pro box_mult_fieldlines_fff, data, ix, iy, x, y, z, _extra = _extra
; data is the bfield in a data structure as returned from
; mult_read_bfield_fff.pro
;      data = {bx:bx, by:by, bz:bz, filename:files[j]}
; One for each data file,
; ix and iy are the subscripts of the line start points,
; x, y, and z are the spatial grids
;-
  tdata = data[0].bz[*, *, 0]
  nx = n_elements(data[0].bz[*, 0, 0])
  ny = n_elements(data[0].bz[0, *, 0])
  zoom_factor = 512/nx
  ss2 = wdefroi(tdata, xv, yv, zoom = zoom_factor)
  twod_subs, ss2, nx, ny, ix, iy
  mult_fieldlines_fff, data, ix, iy, x, y, z, _extra = _extra
  Return
End
