;+
; Uses mult_fieldlines_fff to draw all of the lines out of a box.
Pro Alt_box_mult_fieldlines_fff, data, ix, iy, x, y, z, boxqs = boxqs, $
                                 skip = skip, _extra = _extra
; data is the bfield in a data structure as returned from
; mult_read_bfield_fff.pro
;      data = {bx:bx, by:by, bz:bz, filename:files[j]}
; One for each data file,
; ix and iy are the subscripts of the line start points,
; x, y, and z are the spatial grids
; boxqs = box coordinates [x0, x1, y0, y1]
; skip = every skip'th point is drawn, the default is 1
;-

  tdata = data[0].bz[*, *, 0]
  nx = n_elements(data[0].bz[*, 0, 0])
  ny = n_elements(data[0].bz[0, *, 0])
  If(keyword_set(boxqs)) Then Begin
    x0 = boxqs[0]
    x1 = boxqs[1]
    y0 = boxqs[2]
    y1 = boxqs[3]
  Endif Else Begin
    x0 = 0 & x1 = nx-1
    y0 = 0 & y1 = ny-1
  Endelse
  If(keyword_set(skip)) Then sk = skip Else sk = 1
  nxbox = x1-x0+1
  nybox = y1-y0+1
  nxpts = nxbox/sk
  nypts = nybox/sk
  ix_arr = x0+sk*lindgen(nxpts)
  iy_arr = y0+sk*lindgen(nypts)
  ix = lonarr(nxpts*nypts) & iy = ix
  For j = 0l, nypts-1 Do For i = 0l, nxpts-1 Do Begin
    ss = i+nxpts*j
    ix[ss] = ix_arr[i]
    iy[ss] = iy_arr[j]
  Endfor
  mult_fieldlines_fff, data, ix, iy, x, y, z, _extra = _extra
  Return
End
