/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.jidl.vps.client;

import com.sun.xml.ws.util.ByteArrayDataSource;
import gov.nasa.gsfc.jidl.vps.client.MaskedSignalHandler;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepDataFile;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepInstrument;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepParameter;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepParameterSet;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepRequest;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepResponse;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepResult;
import gov.nasa.gsfc.jidl.vps.server.web.services.PreprocessorWebPortalService;
import gov.nasa.gsfc.jidl.vps.server.web.services.PrepserverUnavailableException_Exception;
import gov.nasa.gsfc.jidl.vps.server.web.services.Prepservice;
import gov.nasa.gsfc.jidl.vps.server.web.services.ResultSTATUS;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.MTOMFeature;

public class PreprocessorClientRequest {
    private static final String WSDL_PATH = "/prepserver/preprocessor?wsdl";
    private static final String[] PREPSERVER_ENDPOINT;
    private static String[] WSDL_LOCATION;
    private static SERVER currentServer;
    @WebServiceRef
    private static Prepservice service;
    private static MaskedSignalHandler globalSignalHandler;
    private PreprocessorWebPortalService port;
    private MaskedSignalHandler signalHandler;
    private PrepParameterSet set;
    private PrepInstrument instrument;
    private PrepRequest request;
    private PrepResponse response;

    public static boolean selectServer(String string) {
        int n = -1;
        try {
            n = SERVER.valueOf(string.toUpperCase()).ordinal();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.print("Given server [] is not valid. Permitted values are [ ");
            for (int i = 0; i < SERVER.values().length; ++i) {
                System.out.print(SERVER.values()[i].toString() + " ");
            }
            System.out.println("]");
            return false;
        }
        try {
            service = new Prepservice(new URL(WSDL_LOCATION[n]));
            currentServer = SERVER.values()[n];
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("An error occurred while switching servers. Please try another server.");
            return false;
        }
        return true;
    }

    public static PreprocessorClientRequest newRequest(String string) {
        return new PreprocessorClientRequest(string);
    }

    private PreprocessorClientRequest(String string) {
        if (!PreprocessorClientRequest.testServer()) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        this.port = service.getPreprocessorWebPortalServicePort(new WebServiceFeature[]{new MTOMFeature(true)});
        Map map = ((BindingProvider)this.port).getRequestContext();
        map.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 8192);
        try {
            this.instrument = this.port.createPrepInstrument(string);
            this.set = this.port.createPrepParameterSet(this.instrument);
            this.request = this.port.createPrepRequest();
            this.request.setParameterSet(this.set);
        }
        catch (PrepserverUnavailableException_Exception prepserverUnavailableException_Exception) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        if (MaskedSignalHandler.isMac()) {
            this.signalHandler = new MaskedSignalHandler();
        }
    }

    public void addParameter(String string, byte by) {
        this.addParameter(string, Byte.toString(by));
    }

    public void addParameter(String string, short s) {
        this.addParameter(string, Short.toString(s));
    }

    public void addParameter(String string, int n) {
        this.addParameter(string, Integer.toString(n));
    }

    public void addParameter(String string, long l) {
        this.addParameter(string, Long.toString(l));
    }

    public void addParameter(String string, float f) {
        this.addParameter(string, Float.toString(f));
    }

    public void addParameter(String string, double d) {
        this.addParameter(string, Double.toString(d));
    }

    public void addParameter(String string, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addParameter(string, Byte.toString(byArray[i]));
        }
    }

    public void addParameter(String string, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            this.addParameter(string, Short.toString(sArray[i]));
        }
    }

    public void addParameter(String string, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addParameter(string, Integer.toString(nArray[i]));
        }
    }

    public void addParameter(String string, long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            this.addParameter(string, Long.toString(lArray[i]));
        }
    }

    public void addParameter(String string, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.addParameter(string, Float.toString(fArray[i]));
        }
    }

    public void addParameter(String string, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addParameter(string, Double.toString(dArray[i]));
        }
    }

    public void addParameter(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addParameter(string, stringArray[i]);
        }
    }

    public void addParameter(String string, String string2) {
        if (!PreprocessorClientRequest.testServer()) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        PrepParameter prepParameter = null;
        for (PrepParameter prepParameter2 : this.set.getParameters()) {
            if (!prepParameter2.getName().equals(string.toLowerCase())) continue;
            prepParameter = prepParameter2;
            break;
        }
        if (prepParameter == null) {
            try {
                prepParameter = this.port.createPrepParameter(string.toLowerCase());
            }
            catch (PrepserverUnavailableException_Exception prepserverUnavailableException_Exception) {
                System.out.println("The PrepServer is currently unavailable. Please try again later.");
                return;
            }
            this.set.getParameters().add(prepParameter);
        }
        prepParameter.getValues().add(string2);
    }

    public void addData(String string) throws IOException {
        if (!PreprocessorClientRequest.testServer()) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        PrepDataFile prepDataFile = null;
        File file = new File(string);
        try {
            if (file.isFile() && file.canRead()) {
                prepDataFile = this.port.createPrepDataFile("file:///" + file.getPath().replace(File.separator, "/").replace(" ", "%32"));
                byte[] byArray = PreprocessorClientRequest.readByteArrayFromFile(file);
                DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(byArray, "application/octet-stream"));
                prepDataFile = this.port.uploadData(dataHandler, prepDataFile);
            } else {
                prepDataFile = this.port.createPrepDataFile(string);
            }
        }
        catch (PrepserverUnavailableException_Exception prepserverUnavailableException_Exception) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        this.request.getDataFiles().add(prepDataFile);
    }

    public void dump() {
        System.out.println("Request: " + this.request.getId() + ", for client: " + this.request.getClientId());
        System.out.println("Set: " + this.set.getId() + ", with parameters:");
        for (PrepParameter object : this.set.getParameters()) {
            System.out.println("\tParameter: " + object.getId() + ", name: " + object.getName() + ", with values:");
            for (String string : object.getValues()) {
                System.out.println("\t\t" + string);
            }
        }
        System.out.println("Data files:");
        for (PrepDataFile prepDataFile : this.request.getDataFiles()) {
            System.out.println("Data file: " + prepDataFile.getId() + ", location: " + prepDataFile.getUri());
        }
        if (this.response != null) {
            System.out.println("Response: " + this.response.getId());
            for (PrepResult prepResult : this.response.getResults()) {
                System.out.println("\tResult: " + prepResult.getId());
                System.out.println("\tStatus: " + (Object)((Object)prepResult.getStatus()));
                System.out.println("\tData: " + prepResult.getDataFile().getUri());
            }
        }
    }

    public void preprocess() throws Exception {
        if (!PreprocessorClientRequest.testServer()) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        if (this.response != null) {
            System.out.println("Response is already available!");
        }
        try {
            this.response = this.port.preprocess(this.request);
        }
        catch (PrepserverUnavailableException_Exception prepserverUnavailableException_Exception) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            return;
        }
        catch (Exception exception) {
            System.out.println("An error has occurred. Please check vso_debug for more information.");
            throw exception;
        }
    }

    public String[] getData() {
        if (this.response == null) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (PrepResult prepResult : this.response.getResults()) {
            if (prepResult != null && prepResult.getStatus() != null && prepResult.getStatus().equals((Object)ResultSTATUS.SUCCESS)) {
                PrepDataFile prepDataFile = prepResult.getDataFile();
                if (prepDataFile != null && prepDataFile.getUri() != null) {
                    linkedList.add(prepResult.getDataFile().getUri());
                    continue;
                }
                System.out.println("No data for '" + prepResult.getId() + "' since prepping has failed.");
                continue;
            }
            System.out.println("No data for '" + prepResult.getId() + "' since prepping has failed.");
        }
        String[] stringArray = new String[linkedList.size()];
        return linkedList.toArray(stringArray);
    }

    private static byte[] readByteArrayFromFile(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[]{};
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byArray = new byte[(int)file.length()];
            bufferedInputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            bufferedInputStream.close();
            fileInputStream.close();
        }
        return byArray;
    }

    public static boolean testServer() {
        boolean bl = false;
        try {
            URL uRL = new URL(WSDL_LOCATION[currentServer.ordinal()]);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(1000);
            uRLConnection.connect();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            bl = string != null && string.startsWith("<?xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        PreprocessorClientRequest.selectServer("wilco");
        PreprocessorClientRequest preprocessorClientRequest = PreprocessorClientRequest.newRequest("euvi");
        preprocessorClientRequest.addData("D:\\Data\\20070125_065540_s4euB.fts");
        preprocessorClientRequest.preprocess();
        String[] stringArray2 = preprocessorClientRequest.getData();
        System.out.println(stringArray2[0]);
    }

    static {
        int n;
        PREPSERVER_ENDPOINT = new String[]{"hesperia.gsfc.nasa.gov", "wilco.gsfc.nasa.gov", "127.0.0.1:8080"};
        WSDL_LOCATION = new String[PREPSERVER_ENDPOINT.length];
        currentServer = SERVER.HESPERIA;
        int n2 = PREPSERVER_ENDPOINT.length;
        for (n = 0; n < n2; ++n) {
            PreprocessorClientRequest.WSDL_LOCATION[n] = "http://" + PREPSERVER_ENDPOINT[n] + WSDL_PATH;
        }
        for (n = 0; n < n2; ++n) {
            currentServer = SERVER.values()[n];
            if (PreprocessorClientRequest.testServer()) break;
        }
        if (!PreprocessorClientRequest.testServer()) {
            System.out.println("The PrepServer is currently unavailable. Please try again later.");
            System.exit(-1);
        }
        try {
            service = new Prepservice(new URL(WSDL_LOCATION[currentServer.ordinal()]));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("An error occurred while initializing the client. Please contact the developer.");
            System.exit(-2);
        }
        if (MaskedSignalHandler.isMac()) {
            globalSignalHandler = new MaskedSignalHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SERVER {
        HESPERIA,
        WILCO,
        TEST;

    }
}

