;+
;  NAME: spherical_to_pfss
; 
;  PURPOSE:
;    This procedure populates the pfss common block variables with the data
;    stored in the given spherical_field_data structure (see
;    spherical_field_data__define.pro).
; 
;  CALLING SEQUENCE:
;    spherical_to_pfss,sph_data
; 
;  INPUTS:
;    sph_data = a structure of type spherical_field_data (see
;      spherical_field_data__define.pro)
; 
;  OUTPUTS: none
; 
;  COMMON BLOCKS:
;    uses pfss common block (see pfss_data_block.pro) as input data
; 
;  NOTES:
;    1.  Those variables in the spherical_field_data structure for which there
;        are no corresponding variables in the pfss common block are not
;        carried over.
;    2.  The temporary function is used here to set variables to undefined.
;    3.  If variables are added to the pfss common block, one needs to add a
;        line to this routine.
;
;  MODIFICATION HISTORY:
;    M.DeRosa - 15 Dec 2005 - created
; 
;-

pro spherical_to_pfss,sph_data

;  access pfss common block
@pfss_data_block

if ptr_valid(sph_data.br) then br=*sph_data.br else dummy=temporary(br)
if ptr_valid(sph_data.bth) then bth=*sph_data.bth else dummy=temporary(bth)
if ptr_valid(sph_data.bph) then bph=*sph_data.bph else dummy=temporary(bph)
if n_elements(sph_data.nr) gt 0 then nr=sph_data.nr else dummy=temporary(nr)
if n_elements(sph_data.nlat) gt 0 $
  then nlat=sph_data.nlat else dummy=temporary(nlat)
if n_elements(sph_data.nlon) gt 0 $
  then nlon=sph_data.nlon else dummy=temporary(nlon)
if ptr_valid(sph_data.rix) then rix=*sph_data.rix else dummy=temporary(rix)
if ptr_valid(sph_data.lat) then lat=*sph_data.lat else dummy=temporary(lat)
if ptr_valid(sph_data.lon) then lon=*sph_data.lon else dummy=temporary(lon)
if ptr_valid(sph_data.theta) $
  then theta=*sph_data.theta else dummy=temporary(theta)
if ptr_valid(sph_data.phi) then phi=*sph_data.phi else dummy=temporary(phi)
if ptr_valid(sph_data.str) then str=*sph_data.str else dummy=temporary(str)
if ptr_valid(sph_data.stth) $
  then stth=*sph_data.stth else dummy=temporary(stth)
if ptr_valid(sph_data.stph) $
  then stph=*sph_data.stph else dummy=temporary(stph)
if ptr_valid(sph_data.ptr) then ptr=*sph_data.ptr else dummy=temporary(ptr)
if ptr_valid(sph_data.ptth) $
  then ptth=*sph_data.ptth else dummy=temporary(ptth)
if ptr_valid(sph_data.ptph) $
  then ptph=*sph_data.ptph else dummy=temporary(ptph)
if ptr_valid(sph_data.nstep) $
  then nstep=*sph_data.nstep else dummy=temporary(nstep)

;  variables in the common block that have no corresponding field in sph_data
if n_elements(l0) gt 0 then dummy=temporary(l0)
if n_elements(b0) gt 0 then dummy=temporary(b0)
if n_elements(now) gt 0 then dummy=temporary(now)
if n_elements(phiat) gt 0 then dummy=temporary(phiat)
if n_elements(phibt) gt 0 then dummy=temporary(phibt)
if n_elements(rimage) gt 0 then dummy=temporary(rimage)

end
